/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.php.Messages;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import com.aptana.editor.php.internal.model.ModelManager;
import com.aptana.editor.php.internal.ui.editor.PHPDocumentProvider;
import com.aptana.editor.php.util.EditorUtils;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PHPEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.editor.php";
    public static final String DEBUG_SCOPE = "com.aptana.editor.php/debug";
    public static final String INDEXER_SCOPE = "com.aptana.editor.php/debug/indexer";
    public static final String BUILDER_ID = "com.aptana.editor.php.aptanaPhpBuilder";
    public static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"com.aptana.editor.php/debug"));
    public static final boolean INDEXER_DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"com.aptana.editor.php/debug/indexer"));
    private static PHPEditorPlugin plugin;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private PHPDocumentProvider phpDocumentProvider;

    public void start(BundleContext context) throws Exception {
        long start = System.currentTimeMillis();
        super.start(context);
        plugin = this;
        ProjectsPlugin.getDefault().getTemplatesManager().addTemplate((IProjectTemplate)new DefaultPHPProjectTemplate());
        if (DEBUG) {
            System.out.println("PHP Plugin - Super start: " + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        this.addThemeListener();
        if (DEBUG) {
            System.out.println("PHP Plugin - Add theme listener: " + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        this.index();
        if (DEBUG) {
            System.out.println("PHP Plugin - index(): " + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        Job loadBuiltins = new Job("Index PHP API..."){

            protected IStatus run(IProgressMonitor monitor) {
                PHPBuiltins.getInstance().getBuiltins();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)loadBuiltins);
        loadBuiltins.setPriority(40);
        loadBuiltins.schedule(2000L);
        if (DEBUG) {
            System.out.println("PHP Plugin - Load Built-ins: " + (System.currentTimeMillis() - start));
        }
    }

    private void addThemeListener() {
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    EditorUtils.setOccurrenceColors();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    private void removeThemeListener() {
        if (this.fThemeChangeListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
            this.fThemeChangeListener = null;
        }
    }

    private void index() {
        Job indexerJob = new Job(Messages.PHPEditorPlugin_indexingJobMessage){

            protected IStatus run(IProgressMonitor monitor) {
                long mark = 0L;
                if (DEBUG) {
                    IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)"PHPPlugin call to PHPGlobalIndexer starts", null, (String)PHPEditorPlugin.DEBUG_SCOPE);
                    mark = System.currentTimeMillis();
                }
                PHPGlobalIndexer.getInstance();
                if (DEBUG) {
                    IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("PHPPlugin call to PHPGlobalIndexer ended (done after " + (System.currentTimeMillis() - mark) + "ms)"), null, (String)PHPEditorPlugin.DEBUG_SCOPE);
                    IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)"PHPPlugin call to ModelManager starts", null, (String)PHPEditorPlugin.DEBUG_SCOPE);
                    mark = System.currentTimeMillis();
                }
                ModelManager.getInstance();
                if (DEBUG) {
                    IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("PHPPlugin call to ModelManager ended (done after " + (System.currentTimeMillis() - mark) + "ms)"), null, (String)PHPEditorPlugin.DEBUG_SCOPE);
                }
                return Status.OK_STATUS;
            }
        };
        indexerJob.setPriority(40);
        indexerJob.schedule(1000L);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            PHPGlobalIndexer.getInstance().save();
            this.removeThemeListener();
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static PHPEditorPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        ImageDescriptor id;
        ImageRegistry registry = plugin.getImageRegistry();
        Image image = registry.get(path);
        if (image == null && (id = PHPEditorPlugin.getImageDescriptor(path)) != null) {
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            Display disp;
            Shell shell = window.getShell();
            if (shell == null && (disp = PlatformUI.getWorkbench().getDisplay()) != null) {
                return disp.getActiveShell();
            }
        }
        return null;
    }

    public synchronized PHPDocumentProvider getPHPDocumentProvider() {
        if (this.phpDocumentProvider == null) {
            this.phpDocumentProvider = new PHPDocumentProvider();
        }
        return this.phpDocumentProvider;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(IStatus status) {
        IdeLog.log((Plugin)PHPEditorPlugin.getDefault(), (IStatus)status);
    }

    public static void log(Throwable e) {
        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
    }

    public static void logError(Throwable e) {
        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
    }

    public static void logError(String message, Throwable e) {
        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)message, (Throwable)e);
    }

    public static void logWarning(String message) {
        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)message, null, null);
    }

    public static void logWarning(String message, Throwable e) {
        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)message, (Throwable)e, null);
    }

    public static void logInfo(String message) {
        IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)message, null);
    }

    private static class DefaultPHPProjectTemplate
    extends ProjectTemplate
    implements IDefaultProjectTemplate {
        private static final String ID = "com.aptana.php.default";

        public DefaultPHPProjectTemplate() {
            super("default.zip", TemplateType.PHP, Messages.PHPEditorPlugin_DefaultPHPProjectTemplate_Name, false, Messages.PHPEditorPlugin_DefaultPHPProjectTemplate_Description, null, ID, 1, CollectionsUtil.newList((Object[])new String[]{"PHP"}));
        }

        public IStatus apply(IProject project, boolean promptForOverwrite) {
            return Status.OK_STATUS;
        }
    }
}

